package pt.caf_pbs.schooldiskapi.model;

import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;

import java.io.Serializable;

public class Person implements Serializable {
    private String name;

    public Person(String name) {
        setName(name);
    }

    private boolean isNameValid(String name) {
        return name.length() >= 3;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (isNameValid(name)) {
            this.name = name;
        } else {

            String msg = "Person: " + name;
            throw new InvalidDataException(msg);
        }
    }
}
